/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.language;

import com.nvidia.cuda.ide.language.SMVersion;
import java.util.Map;
import org.eclipse.cdt.core.dom.parser.cpp.GPPScannerExtensionConfiguration;
import org.eclipse.cdt.core.parser.IScannerInfo;

public final class CudaScannerExtensionsConfiguration
extends GPPScannerExtensionConfiguration {
    private static GPPScannerExtensionConfiguration CONFIG;
    private static GPPScannerExtensionConfiguration CONFIG_4_3;
    public static final String GENERATING_INDEX = "generatingIndex";
    private static final int VERSION_4_3;

    static {
        VERSION_4_3 = CudaScannerExtensionsConfiguration.version((int)4, (int)3);
        CONFIG = new CudaScannerExtensionsConfiguration();
        CONFIG_4_3 = new CudaScannerExtensionsConfiguration(VERSION_4_3);
    }

    public static GPPScannerExtensionConfiguration getInstance() {
        return CONFIG;
    }

    public static GPPScannerExtensionConfiguration getInstance(IScannerInfo info) {
        if (info != null) {
            try {
                Map definedSymbols = info.getDefinedSymbols();
                int major = Integer.valueOf((String)definedSymbols.get("__GNUC__"));
                int minor = Integer.valueOf((String)definedSymbols.get("__GNUC_MINOR__"));
                int version = CudaScannerExtensionsConfiguration.version((int)major, (int)minor);
                if (version >= VERSION_4_3) {
                    return CONFIG_4_3;
                }
            }
            catch (Exception exception) {}
        }
        return CONFIG;
    }

    public CudaScannerExtensionsConfiguration() {
        this(0);
    }

    public CudaScannerExtensionsConfiguration(int gccVersion) {
        super(gccVersion);
        this.addKeyword("__managed__".toCharArray(), 65546);
        this.addKeyword("__shared__".toCharArray(), 65545);
        this.addKeyword("__global__".toCharArray(), 65541);
        this.addKeyword("__device__".toCharArray(), 65540);
        this.addKeyword("__host__".toCharArray(), 65542);
        this.addKeyword("__const__".toCharArray(), 65539);
        this.addKeyword("__constant__".toCharArray(), 65539);
        this.addKeyword("__restrict__".toCharArray(), 137);
        this.addKeyword("__launch_bounds__".toCharArray(), 65543);
        this.addMacro("__noinline__", "");
        this.addMacro("__align__(n)", "");
        this.addMacro("__forceinline__", "");
        this.addMacro("__launch_bounds__(maxThreadsPerBlock, minBlocksPerMultiprocessor)", "");
        if (System.getProperty(GENERATING_INDEX) != null) {
            this.addIndexGenerationHelpers();
        }
    }

    private void addIndexGenerationHelpers() {
        SMVersion current = SMVersion.getCurrent();
        if (current != null) {
            String[] macros;
            String[][] versionAgnosticMacros;
            this.addMacro("__CUDA_ARCH__", current.getArch());
            String[][] stringArray = versionAgnosticMacros = SMVersion.getVersionAgnosticMacros();
            int n = versionAgnosticMacros.length;
            int n2 = 0;
            while (n2 < n) {
                String[] macro = stringArray[n2];
                this.addMacro(macro[0], macro[1]);
                ++n2;
            }
            String[] stringArray2 = macros = current.getMacros();
            int n3 = macros.length;
            n = 0;
            while (n < n3) {
                String macro = stringArray2[n];
                this.addMacro(macro, "");
                ++n;
            }
        }
    }
}

