/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.ui.connection;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.remote.connection.ConnectionEditorDelegate;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.internal.ui.connection.ConnectionDetailsPane;
import com.nvidia.cuda.ide.remote.internal.ui.connection.ConnectionWorkingCopy;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class ConnectionsWizardPage
extends WizardPage {
    private static final String DEFAULT_MESSAGE = "Manage available connections";
    private Button btnRemove;
    private TableViewer connectionsList;
    private final List<ConnectionWorkingCopy> list;
    private final IObservableValue selection;
    private ConnectionDetailsPane connectionDetailsPane;
    private final List<ConnectionWorkingCopy> removed;
    private final ConnectionEditorDelegate delegate;

    private static int statusToMessageProviderSeverity(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public ConnectionsWizardPage(IObservableValue selection, List<ConnectionWorkingCopy> connections, List<ConnectionWorkingCopy> removed, ConnectionEditorDelegate delegate) {
        super("connections", "Setup Remote Connections", null);
        this.removed = removed;
        this.delegate = delegate;
        this.setDescription("Configure connections to remote systems");
        this.list = connections;
        this.selection = selection;
    }

    private boolean confirmRemoveConnection(ConnectionWorkingCopy connection) {
        return MessageDialog.openConfirm((Shell)this.getShell(), (String)"Deleting Connection", (String)String.format("Are you sure you want to remove connection %s?", connection.getProperty(ConnectionWorkingCopy.PROPERTY_LABEL)));
    }

    public void createControl(Composite parent) {
        this.setMessage("Manage remote systems connection settings");
        this.setTitle("Remote Connections");
        Composite body = new Composite(parent, 0x400000);
        body.setLayout((Layout)new FormLayout());
        body.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.connectionsList = new TableViewer(body, 67584);
        Table table = this.connectionsList.getTable();
        this.connectionsList.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.connectionsList.setInput(this.list);
        Composite composite = new Composite(body, 0);
        FormData fd_composite = new FormData();
        fd_composite.right = new FormAttachment(100);
        fd_composite.top = new FormAttachment(0);
        composite.setLayoutData((Object)fd_composite);
        FillLayout fl_composite = new FillLayout();
        fl_composite.type = 512;
        composite.setLayout((Layout)fl_composite);
        Button btnAdd = new Button(composite, 0);
        btnAdd.setText("Add");
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionWorkingCopy connection = new ConnectionWorkingCopy(null, ConnectionsWizardPage.this.list, ConnectionsWizardPage.this.getRealm());
                ConnectionsWizardPage.this.list.add(connection);
                ConnectionsWizardPage.this.connectionsList.setSelection((ISelection)new StructuredSelection((Object)connection), true);
                ConnectionsWizardPage.this.connectionDetailsPane.setFocus();
            }
        });
        this.btnRemove = new Button(composite, 0);
        this.btnRemove.setText("Remove");
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionsWizardPage.this.deleteConnection();
            }
        });
        this.connectionDetailsPane = new ConnectionDetailsPane(body, 0);
        FormData fd_connectionDetailsPane = new FormData();
        fd_connectionDetailsPane.bottom = new FormAttachment(100);
        fd_connectionDetailsPane.right = new FormAttachment(100);
        fd_connectionDetailsPane.left = new FormAttachment(0);
        this.connectionDetailsPane.setLayoutData(fd_connectionDetailsPane);
        FormData fd_table = new FormData();
        fd_table.bottom = new FormAttachment((Control)this.connectionDetailsPane, -6);
        fd_table.top = new FormAttachment(0);
        fd_table.right = new FormAttachment((Control)composite, -6);
        fd_table.left = new FormAttachment(0);
        table.setLayoutData((Object)fd_table);
        this.setupBindings();
        this.setControl((Control)body);
    }

    private Realm getRealm() {
        return SWTObservables.getRealm((Display)this.getShell().getDisplay());
    }

    private void setupBindings() {
        DataBindingContext context = new DataBindingContext(this.getRealm());
        final IViewerObservableValue selection = ViewersObservables.observeSingleSelection((Viewer)this.connectionsList);
        context.bindValue((IObservableValue)selection, this.selection);
        context.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.btnRemove), (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                Object value = selection.getValue();
                if (value instanceof ConnectionWorkingCopy) {
                    IRemoteConnection connection = ((ConnectionWorkingCopy)value).getRSEConnection();
                    if (connection != null && !ConnectionsWizardPage.this.delegate.canDelete(connection)) {
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
        context.bindValue((IObservableValue)new AbstractObservableValue(){

            protected Object doGetValue() {
                return null;
            }

            protected void doSetValue(Object value) {
                ConnectionsWizardPage.this.updatePageStatus((IStatus)value);
            }

            public Object getValueType() {
                return IStatus.class;
            }
        }, (IObservableValue)new ComputedValue(IStatus.class){

            protected Object calculate() {
                return ConnectionsWizardPage.this.validate();
            }
        }, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        this.connectionsList.setLabelProvider((IBaseLabelProvider)new ConnectionLabelProvider());
        this.connectionDetailsPane.bind(context, (IObservableValue)selection);
    }

    protected void updatePageStatus(IStatus status) {
        boolean pageComplete = true;
        this.setMessage(DEFAULT_MESSAGE);
        if (status != null && !CoreUtil.isNullOrEmpty((String)status.getMessage())) {
            this.setMessage(status.getMessage(), ConnectionsWizardPage.statusToMessageProviderSeverity(status));
            pageComplete = status.getSeverity() != 4;
        }
        this.setPageComplete(pageComplete);
    }

    protected IStatus validate() {
        HashSet<String> labels = new HashSet<String>();
        for (ConnectionWorkingCopy connection : this.list) {
            String label = connection.getProperty(ConnectionWorkingCopy.PROPERTY_LABEL);
            if (CoreUtil.isNullOrEmpty((String)connection.getProperty(ConnectionWorkingCopy.PROPERTY_HOST))) {
                return CoreUtil.errorStatus((String)"Host name is not specified for connection %s", (Object[])new Object[]{label});
            }
            if (labels.add(label)) continue;
            return CoreUtil.errorStatus((String)"Duplicate connection name %s", (Object[])new Object[]{label});
        }
        return CoreUtil.OK_STATUS;
    }

    private void deleteConnection() {
        ConnectionWorkingCopy connection = (ConnectionWorkingCopy)CoreUtil.getSelectedObject((ISelectionProvider)this.connectionsList, ConnectionWorkingCopy.class);
        if (connection != null && (connection.isEmpty() || this.confirmRemoveConnection(connection))) {
            int i = this.list.indexOf(connection);
            this.list.remove(i);
            this.removed.add(connection);
            if (!this.list.isEmpty()) {
                int newSelection = Math.min(i, this.list.size() - 1);
                this.connectionsList.setSelection((ISelection)new StructuredSelection((Object)this.list.get(newSelection)));
            }
        }
    }

    private final class ConnectionLabelProvider
    extends LabelProvider
    implements IValueChangeListener {
        private final Set<WeakReference<ConnectionWorkingCopy>> listened = new HashSet<WeakReference<ConnectionWorkingCopy>>();

        private ConnectionLabelProvider() {
        }

        public void dispose() {
            for (WeakReference<ConnectionWorkingCopy> ref : this.listened) {
                ConnectionWorkingCopy connection = (ConnectionWorkingCopy)ref.get();
                if (connection == null) continue;
                connection.observeProperty(ConnectionWorkingCopy.PROPERTY_LABEL).removeValueChangeListener((IValueChangeListener)this);
            }
        }

        public String getText(Object element) {
            ConnectionWorkingCopy connection = (ConnectionWorkingCopy)element;
            WeakReference<ConnectionWorkingCopy> ref = new WeakReference<ConnectionWorkingCopy>(connection);
            if (!this.listened.contains(ref)) {
                connection.observeProperty(ConnectionWorkingCopy.PROPERTY_LABEL).addValueChangeListener((IValueChangeListener)this);
                this.listened.add(ref);
            }
            return connection.getProperty(ConnectionWorkingCopy.PROPERTY_LABEL);
        }

        public void handleValueChange(ValueChangeEvent event) {
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }
}

