/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.projectconverter;

import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.projectconverter.ConverterMessages;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class UpdateManagedProject12 {
    private static final String ID_CYGWIN = "cygwin";
    private static final String ID_DEBUG = "debug";
    private static final String ID_DIRS = "dirs";
    private static final String ID_EXE = "exe";
    private static final String ID_EXEC = "exec";
    private static final String ID_GENERAL = "general";
    private static final String ID_GNU = "gnu";
    private static final String ID_INCPATHS = "incpaths";
    private static final String ID_INCLUDE = "include";
    private static final String ID_LIBS = "libs";
    private static final String ID_LINUX = "linux";
    private static final String ID_OPTION = "option";
    private static final String ID_OPTIONS = "options";
    private static final String ID_PATHS = "paths";
    private static final String ID_PREPROC = "preprocessor";
    private static final String ID_SEPARATOR = ".";
    private static final String ID_SHARED = "so";
    private static final String ID_SOLARIS = "solaris";
    private static final String ID_STATIC = "lib";
    private static final String NEW_CONFIG_ROOT = "cdt.managedbuild.config.gnu";
    private static final String NEW_CYGWIN_TARGET_ROOT = "cdt.managedbuild.target.gnu.cygwin";
    private static final String NEW_POSIX_TARGET_ROOT = "cdt.managedbuild.target.gnu";
    private static final String NEW_TOOL_ROOT = "cdt.managedbuild.tool.gnu";
    private static final String OLD_TOOL_ROOT_LONG = "org.eclipse.cdt.build.tool";
    private static final String OLD_TOOL_ROOT_SHORT = "cdt.build.tool";
    private static final String REGEXP_SEPARATOR = "\\.";
    private static final String TOOL_LANG_BOTH = "both";
    private static final String TOOL_LANG_C = "c";
    private static final String TOOL_LANG_CPP = "cpp";
    private static final String TOOL_NAME_AR = "ar";
    private static final String TOOL_NAME_ARCHIVER = "archiver";
    private static final String TOOL_NAME_COMPILER = "compiler";
    private static final String TOOL_NAME_LIB = "lib";
    private static final String TOOL_NAME_LINK = "link";
    private static final String TOOL_NAME_LINKER = "linker";
    private static final String TOOL_NAME_SOLINK = "solink";
    private static final int TOOL_TYPE_COMPILER = 0;
    private static final int TOOL_TYPE_LINKER = 1;
    private static final int TOOL_TYPE_ARCHIVER = 2;
    private static final int TYPE_EXE = 0;
    private static final int TYPE_SHARED = 1;
    private static final int TYPE_STATIC = 2;
    private static Map<String, IConfiguration> configIdMap;

    UpdateManagedProject12() {
    }

    protected static String getNewConfigurationId(String oldId) {
        boolean builtIn = false;
        boolean cygwin = false;
        boolean debug = false;
        int type = -1;
        Vector<String> idTokens = new Vector<String>(Arrays.asList(oldId.split(REGEXP_SEPARATOR)));
        try {
            String platform = idTokens.get(0);
            if (platform.equalsIgnoreCase(ID_CYGWIN)) {
                builtIn = true;
                cygwin = true;
            } else if ((platform.equalsIgnoreCase(ID_LINUX) || platform.equalsIgnoreCase(ID_SOLARIS)) && idTokens.get(1).equalsIgnoreCase(ID_GNU)) {
                builtIn = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            builtIn = false;
        }
        if (!builtIn) {
            return oldId;
        }
        for (String id : idTokens) {
            if (id.equalsIgnoreCase(ID_EXEC)) {
                type = 0;
                continue;
            }
            if (id.equalsIgnoreCase(ID_SHARED)) {
                type = 1;
                continue;
            }
            if (id.equalsIgnoreCase("lib")) {
                type = 2;
                continue;
            }
            if (!id.equalsIgnoreCase(ID_DEBUG)) continue;
            debug = true;
        }
        String defId = "cdt.managedbuild.config.gnu.";
        if (cygwin) {
            defId = String.valueOf(defId) + "cygwin.";
        }
        switch (type) {
            case 0: {
                defId = String.valueOf(defId) + ID_EXE;
                break;
            }
            case 1: {
                defId = String.valueOf(defId) + ID_SHARED;
                break;
            }
            case 2: {
                defId = String.valueOf(defId) + "lib";
            }
        }
        defId = String.valueOf(defId) + ID_SEPARATOR + (debug ? ID_DEBUG : "release");
        return defId;
    }

    protected static void convertConfiguration(IManagedProject newProject, IProjectType newParent, Element oldConfig, IProgressMonitor monitor) throws CoreException {
        IConfiguration newParentConfig = null;
        IConfiguration newConfig = null;
        String parentId = oldConfig.getAttribute("parent");
        newParentConfig = newParent.getConfiguration(parentId = UpdateManagedProject12.getNewConfigurationId(parentId));
        if (newParentConfig == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getFormattedString("UpdateManagedProject12.2", parentId), null));
        }
        int randomElement = ManagedBuildManager.getRandomNumber();
        String newConfigId = String.valueOf(parentId) + ID_SEPARATOR + randomElement;
        newConfig = newProject.createConfiguration(newParentConfig, newConfigId);
        newConfig.setName(oldConfig.getAttribute("name"));
        Element oldTarget = (Element)oldConfig.getParentNode();
        if (oldTarget.hasAttribute("artifactName")) {
            String buildGoal = oldTarget.getAttribute("artifactName");
            String[] nameElements = buildGoal.split(REGEXP_SEPARATOR);
            String name = null;
            try {
                name = nameElements[0];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                name = "default";
            }
            String extension = new String();
            int index = 1;
            while (index < nameElements.length) {
                extension = String.valueOf(extension) + nameElements[index];
                if (index < nameElements.length - 1) {
                    extension = String.valueOf(extension) + ID_SEPARATOR;
                }
                ++index;
            }
            newConfig.setArtifactName(name);
            if (extension.length() != 0) {
                newConfig.setArtifactExtension(extension);
            }
        }
        IToolChain toolChain = newConfig.getToolChain();
        ((ToolChain)toolChain).checkForMigrationSupport();
        NodeList toolRefNodes = oldConfig.getElementsByTagName("toolReference");
        int refIndex = 0;
        while (refIndex < toolRefNodes.getLength()) {
            try {
                UpdateManagedProject12.convertToolRef(toolChain, (Element)toolRefNodes.item(refIndex), monitor);
            }
            catch (CoreException e) {
                newProject.removeConfiguration(newConfigId);
                throw e;
            }
            ++refIndex;
        }
        UpdateManagedProject12.getConfigIdMap().put(oldConfig.getAttribute("id"), newConfig);
        monitor.worked(1);
    }

    protected static String getNewOptionId(IToolChain toolChain, ITool tool, String oldId) throws CoreException {
        String optId = null;
        String[] idTokens = oldId.split(REGEXP_SEPARATOR);
        Vector<String> oldIdVector = new Vector<String>(Arrays.asList(idTokens));
        if (UpdateManagedProject12.isBuiltInOption(oldIdVector)) {
            int dirIndex;
            int generalIndex;
            String toolToken;
            String langToken;
            Vector<String> newIdVector = new Vector<String>(idTokens.length + 2);
            int index = 1;
            while (index < idTokens.length) {
                newIdVector.add(idTokens[index]);
                ++index;
            }
            if (!((String)newIdVector.firstElement()).equals(ID_GNU)) {
                newIdVector.add(0, ID_GNU);
            }
            if (!(langToken = (String)newIdVector.get(1)).equals(TOOL_LANG_C)) {
                if (langToken.equals("lib") || langToken.equals(TOOL_NAME_AR)) {
                    newIdVector.add(1, TOOL_LANG_BOTH);
                } else {
                    newIdVector.add(1, TOOL_LANG_CPP);
                }
            }
            if ((toolToken = (String)newIdVector.get(2)).equals(ID_PREPROC)) {
                newIdVector.add(2, TOOL_NAME_COMPILER);
            } else if (toolToken.equals(TOOL_NAME_LINKER) || toolToken.equals(TOOL_NAME_SOLINK)) {
                newIdVector.remove(2);
                newIdVector.add(2, TOOL_NAME_LINK);
            } else if (toolToken.equals(TOOL_NAME_AR)) {
                newIdVector.remove(2);
                newIdVector.add(2, "lib");
            }
            String optionToken = (String)newIdVector.get(3);
            if (optionToken.equals(ID_OPTIONS)) {
                newIdVector.remove(3);
            }
            newIdVector.add(3, ID_OPTION);
            String badToken = (String)newIdVector.lastElement();
            if (badToken.equals(ID_INCPATHS)) {
                newIdVector.remove(newIdVector.lastElement());
                newIdVector.addElement(ID_INCLUDE);
                newIdVector.addElement(ID_PATHS);
            }
            if ((generalIndex = newIdVector.indexOf(ID_GENERAL)) != -1) {
                newIdVector.remove(generalIndex);
            }
            if ((dirIndex = newIdVector.indexOf(ID_DIRS)) != -1) {
                newIdVector.remove(dirIndex);
            }
            try {
                if ((((String)newIdVector.lastElement()).equals(ID_PATHS) || ((String)newIdVector.lastElement()).equals(ID_LIBS)) && ((String)newIdVector.get(newIdVector.size() - 2)).equals(ID_LIBS)) {
                    newIdVector.remove(newIdVector.size() - 2);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            optId = new String();
            int rebuildIndex = 0;
            while (rebuildIndex < newIdVector.size()) {
                String token = (String)newIdVector.get(rebuildIndex);
                optId = String.valueOf(optId) + token;
                if (rebuildIndex < newIdVector.size() - 1) {
                    optId = String.valueOf(optId) + ID_SEPARATOR;
                }
                ++rebuildIndex;
            }
        } else {
            optId = oldId;
        }
        toolChain.getParent();
        IOption[] options = tool.getOptions();
        int i = 0;
        while (i < options.length) {
            String parentId;
            IOption curOption = options[i];
            IOption parent = curOption.getSuperClass();
            String curOptionId = curOption.getId();
            if (!(parent == null ? !curOptionId.equals(optId) : !(parentId = parent.getId()).equals(optId))) {
                return curOption.getId();
            }
            ++i;
        }
        return optId;
    }

    protected static void convertOptionRef(IToolChain toolChain, ITool tool, Element optRef) throws CoreException {
        String optId = optRef.getAttribute("id");
        if (optId == null) {
            return;
        }
        IOption newOpt = tool.getOptionById(optId = UpdateManagedProject12.getNewOptionId(toolChain, tool, optId));
        if (newOpt != null) {
            IConfiguration configuration = toolChain.getParent();
            try {
                switch (newOpt.getValueType()) {
                    case 0: {
                        Boolean bool = new Boolean(optRef.getAttribute("defaultValue"));
                        configuration.setOption((IHoldsOptions)tool, newOpt, bool);
                        break;
                    }
                    case 2: {
                        String strVal = optRef.getAttribute("defaultValue");
                        configuration.setOption((IHoldsOptions)tool, newOpt, strVal);
                        break;
                    }
                    case 1: {
                        String name = optRef.getAttribute("defaultValue");
                        String idValue = newOpt.getEnumeratedId(name);
                        if (idValue == null) {
                            name = (String)newOpt.getDefaultValue();
                        }
                        configuration.setOption((IHoldsOptions)tool, newOpt, idValue != null ? idValue : name);
                        break;
                    }
                    case 12: {
                        String name = optRef.getAttribute("defaultValue");
                        String idValue = newOpt.getId(name);
                        if (idValue == null) {
                            name = (String)newOpt.getDefaultValue();
                        }
                        configuration.setOption((IHoldsOptions)tool, newOpt, idValue != null ? idValue : name);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        Vector<String> values = new Vector<String>();
                        NodeList nodes = optRef.getElementsByTagName("listOptionValue");
                        int i = 0;
                        while (i < nodes.getLength()) {
                            Boolean isBuiltIn;
                            Node node = nodes.item(i);
                            if (node.getNodeType() == 1 && !(isBuiltIn = new Boolean(((Element)node).getAttribute("builtIn"))).booleanValue()) {
                                values.add(((Element)node).getAttribute("value"));
                            }
                            ++i;
                        }
                        configuration.setOption((IHoldsOptions)tool, newOpt, values.toArray(new String[values.size()]));
                    }
                }
            }
            catch (BuildException e) {
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getFormattedString("UpdateManagedProject12.5", e.getMessage()), (Throwable)e));
            }
        }
    }

    protected static String getNewProjectId(String oldId) {
        int type = -1;
        boolean posix = false;
        boolean builtIn = false;
        Vector<String> idTokens = new Vector<String>(Arrays.asList(oldId.split(REGEXP_SEPARATOR)));
        try {
            String platform = idTokens.get(0);
            if (platform.equalsIgnoreCase(ID_CYGWIN)) {
                builtIn = true;
            } else if ((platform.equalsIgnoreCase(ID_LINUX) || platform.equalsIgnoreCase(ID_SOLARIS)) && idTokens.get(1).equalsIgnoreCase(ID_GNU)) {
                builtIn = true;
                posix = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            builtIn = false;
        }
        if (!builtIn) {
            return oldId;
        }
        for (String token : idTokens) {
            if (token.equalsIgnoreCase(ID_EXEC)) {
                type = 0;
                continue;
            }
            if (token.equalsIgnoreCase(ID_SHARED)) {
                type = 1;
                continue;
            }
            if (!token.equalsIgnoreCase("lib")) continue;
            type = 2;
        }
        String defID = String.valueOf(posix ? NEW_POSIX_TARGET_ROOT : NEW_CYGWIN_TARGET_ROOT) + ID_SEPARATOR;
        switch (type) {
            case 0: {
                defID = String.valueOf(defID) + ID_EXE;
                break;
            }
            case 1: {
                defID = String.valueOf(defID) + ID_SHARED;
                break;
            }
            case 2: {
                defID = String.valueOf(defID) + "lib";
            }
        }
        return defID;
    }

    protected static IManagedProject convertTarget(IProject project, Element oldTarget, IProgressMonitor monitor) throws CoreException {
        IManagedProject newProject = null;
        IProjectType newParent = null;
        String id = oldTarget.getAttribute("parent");
        String parentID = UpdateManagedProject12.getNewProjectId(id);
        newParent = ManagedBuildManager.getProjectType(parentID);
        if (newParent == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getFormattedString("UpdateManagedProject12.6", parentID), null));
        }
        try {
            newProject = ManagedBuildManager.createManagedProject((IResource)project, newParent);
            NodeList configNodes = oldTarget.getElementsByTagName("configuration");
            int configIndex = 0;
            while (configIndex < configNodes.getLength()) {
                try {
                    UpdateManagedProject12.convertConfiguration(newProject, newParent, (Element)configNodes.item(configIndex), monitor);
                }
                catch (CoreException coreException) {}
                ++configIndex;
            }
        }
        catch (BuildException e) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getFormattedString("UpdateManagedProject12.8", new String[]{project.getName(), e.getMessage()}), null));
        }
        monitor.worked(1);
        return newProject;
    }

    protected static String getNewToolId(IToolChain toolChain, String oldId) throws CoreException {
        String toolId = null;
        if (!oldId.startsWith(OLD_TOOL_ROOT_SHORT) && !oldId.startsWith(OLD_TOOL_ROOT_LONG)) {
            toolId = oldId;
        } else {
            toolId = NEW_TOOL_ROOT;
            boolean cppFlag = true;
            int toolType = -1;
            Vector<String> idTokens = new Vector<String>(Arrays.asList(oldId.split(REGEXP_SEPARATOR)));
            for (String token : idTokens) {
                if (token.equals(TOOL_LANG_C)) {
                    cppFlag = false;
                    continue;
                }
                if (token.equalsIgnoreCase(TOOL_NAME_COMPILER)) {
                    toolType = 0;
                    continue;
                }
                if (token.equalsIgnoreCase(TOOL_NAME_AR)) {
                    toolType = 2;
                    continue;
                }
                if (token.equalsIgnoreCase("lib")) {
                    toolType = 2;
                    continue;
                }
                if (token.equalsIgnoreCase(TOOL_NAME_LINK)) {
                    toolType = 1;
                    continue;
                }
                if (!token.equalsIgnoreCase(TOOL_NAME_SOLINK)) continue;
                toolType = 1;
            }
            toolId = String.valueOf(toolId) + ID_SEPARATOR + (cppFlag ? TOOL_LANG_CPP : TOOL_LANG_C) + ID_SEPARATOR;
            switch (toolType) {
                case 0: {
                    toolId = String.valueOf(toolId) + TOOL_NAME_COMPILER;
                    break;
                }
                case 1: {
                    toolId = String.valueOf(toolId) + TOOL_NAME_LINKER;
                    break;
                }
                case 2: {
                    toolId = String.valueOf(toolId) + TOOL_NAME_ARCHIVER;
                }
            }
        }
        IConfiguration configuration = toolChain.getParent();
        ITool[] tools = configuration.getTools();
        if (tools == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getResourceString("UpdateManagedProject12.9"), null));
        }
        int i = 0;
        while (i < tools.length) {
            block20: {
                ITool curTool = tools[i];
                ITool parent = curTool.getSuperClass();
                String curToolId = curTool.getId();
                while (parent != null) {
                    String parentId = parent.getId();
                    if (parentId.equals(toolId)) break;
                    parent = parent.getSuperClass();
                }
                if (parent != null) {
                    try {
                        Integer.decode(curToolId.substring(curToolId.lastIndexOf(46) + 1));
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        break block20;
                    }
                    catch (NumberFormatException numberFormatException) {
                        break block20;
                    }
                    return curTool.getId();
                }
            }
            ++i;
        }
        throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getFormattedString("UpdateManagedProject12.10", toolId), null));
    }

    protected static void convertToolRef(IToolChain toolChain, Element oldToolRef, IProgressMonitor monitor) throws CoreException {
        String toolId = oldToolRef.getAttribute("id");
        toolId = UpdateManagedProject12.getNewToolId(toolChain, toolId);
        IConfiguration configuration = toolChain.getParent();
        ITool newTool = configuration.getTool(toolId);
        if (newTool == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getFormattedString("UpdateManagedProject12.11", toolId), null));
        }
        ((Tool)newTool).checkForMigrationSupport();
        NodeList optRefs = oldToolRef.getElementsByTagName("optionReference");
        int refIndex = optRefs.getLength() - 1;
        while (refIndex >= 0) {
            UpdateManagedProject12.convertOptionRef(toolChain, newTool, (Element)optRefs.item(refIndex));
            --refIndex;
        }
        monitor.worked(1);
    }

    public static void doProjectUpdate(IProgressMonitor monitor, IProject project) throws CoreException {
        String[] projectName = new String[]{project.getName()};
        IFile file = project.getFile(".cdtbuild");
        File settingsFile = file.getLocation().toFile();
        if (!settingsFile.exists()) {
            monitor.done();
            return;
        }
        monitor.beginTask(ConverterMessages.getFormattedString("UpdateManagedProject12.0", projectName), 1);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        UpdateManagedProjectManager.backupFile(file, "_12backup", monitor, project);
        IManagedProject newProject = null;
        try {
            try {
                FileInputStream stream = new FileInputStream(settingsFile);
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = parser.parse(stream);
                NodeList targetNodes = document.getElementsByTagName("target");
                int listSize = targetNodes.getLength();
                monitor.beginTask(ConverterMessages.getFormattedString("UpdateManagedProject12.1", projectName), listSize * 9);
                int targIndex = 0;
                while (targIndex < listSize) {
                    Element oldTarget = (Element)targetNodes.item(targIndex);
                    String oldTargetId = oldTarget.getAttribute("id");
                    newProject = UpdateManagedProject12.convertTarget(project, oldTarget, monitor);
                    if (newProject != null) {
                        info.removeTarget(oldTargetId);
                        monitor.worked(1);
                    }
                    ++targIndex;
                }
                NodeList defaultConfiguration = document.getElementsByTagName("defaultConfig");
                try {
                    Element defaultConfig = (Element)defaultConfiguration.item(0);
                    String oldDefaultConfigId = defaultConfig.getAttribute("id");
                    IConfiguration newDefaultConfig = UpdateManagedProject12.getConfigIdMap().get(oldDefaultConfigId);
                    if (newDefaultConfig != null) {
                        info.setDefaultConfiguration(newDefaultConfig);
                        info.setSelectedConfiguration(newDefaultConfig);
                    } else {
                        IConfiguration[] newConfigs = newProject.getConfigurations();
                        if (newConfigs.length > 0) {
                            info.setDefaultConfiguration(newConfigs[0]);
                            info.setSelectedConfiguration(newConfigs[0]);
                        }
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ConverterMessages.getFormattedString("UpdateManagedProject12.7", newProject.getName()), null));
                }
                ((ManagedBuildInfo)info).setVersion("2.1.0");
                info.setValid(true);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, e.getMessage(), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            IWorkspace workspace = project.getWorkspace();
            ISchedulingRule rule = workspace.getRuleFactory().createRule((IResource)project);
            WorkspaceJob job = new WorkspaceJob(ConverterMessages.getResourceString("UpdateManagedProject.notice"), project){
                private final /* synthetic */ IProject val$project;
                {
                    this.val$project = iProject;
                    super($anonymous0);
                }

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    ManagedBuildManager.saveBuildInfoLegacy(this.val$project, false);
                    return Status.OK_STATUS;
                }
            };
            job.setRule(rule);
            job.schedule();
            monitor.done();
            throw throwable;
        }
        IWorkspace workspace = project.getWorkspace();
        ISchedulingRule rule = workspace.getRuleFactory().createRule((IResource)project);
        WorkspaceJob job = new /* invalid duplicate definition of identical inner class */;
        job.setRule(rule);
        job.schedule();
        monitor.done();
    }

    protected static Map<String, IConfiguration> getConfigIdMap() {
        if (configIdMap == null) {
            configIdMap = new HashMap<String, IConfiguration>();
        }
        return configIdMap;
    }

    protected static boolean isBuiltInOption(Vector<String> idTokens) {
        block11: {
            String secondToken;
            String platform;
            block10: {
                block9: {
                    platform = idTokens.firstElement();
                    secondToken = idTokens.get(1);
                    if (!platform.equals(ID_CYGWIN)) break block9;
                    if (secondToken.equals(TOOL_NAME_COMPILER) || secondToken.equals(ID_PREPROC) || secondToken.equals(TOOL_LANG_C) || secondToken.equals(ID_GNU) || secondToken.equals(TOOL_NAME_LINK) || secondToken.equals(TOOL_NAME_SOLINK) || secondToken.equals(TOOL_NAME_AR)) {
                        return true;
                    }
                }
                if (!platform.equals(ID_LINUX)) break block10;
                if (secondToken.equals(ID_GNU) || secondToken.equals(TOOL_LANG_C)) {
                    return true;
                }
            }
            try {
                if (platform.equals(ID_SOLARIS)) {
                    if (secondToken.equals(ID_GNU) || secondToken.equals(TOOL_LANG_C) || secondToken.equals(TOOL_NAME_COMPILER)) {
                        return true;
                    }
                    break block11;
                }
                return false;
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return false;
            }
        }
        return false;
    }
}

