#ifndef __MARTIAN_SYSDEP_H
#define __MARTIAN_SYSDEP_H

#include <time.h>
typedef struct _timer {
	timer_t id;
	typeof (timer_settime) *settime;
} mtimer_t;

long mtimer_create (clockid_t clock, struct sigevent *ev, mtimer_t *timer); 

#ifndef sigev_notify_thread_id
# define sigev_notify_thread_id 	_sigev_un._tid
#endif

int mthread_create (void *(*run) (void *arg), void *arg);

struct _mutex;
typedef struct _mutex mutex_t;

mutex_t *mutex_create (void ); 
int mutex_lock (mutex_t *m); 
int mutex_unlock (mutex_t *m);

int mgettid (void);
#endif /*__MARTIAN_SYSDEP_H */
