/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractSAMHeaderRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.util.Iso8601Date;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SAMReadGroupRecord
extends AbstractSAMHeaderRecord {
    private String mReadGroupId = null;
    public static final String READ_GROUP_ID_TAG = "ID";
    public static final String SEQUENCING_CENTER_TAG = "CN";
    public static final String DESCRIPTION_TAG = "DS";
    public static final String DATE_RUN_PRODUCED_TAG = "DT";
    public static final String FLOW_ORDER_TAG = "FO";
    public static final String KEY_SEQUENCE_TAG = "KS";
    public static final String LIBRARY_TAG = "LB";
    public static final String PROGRAM_GROUP_TAG = "PG";
    public static final String PREDICTED_MEDIAN_INSERT_SIZE_TAG = "PI";
    public static final String PLATFORM_TAG = "PL";
    public static final String PLATFORM_MODEL_TAG = "PM";
    public static final String PLATFORM_UNIT_TAG = "PU";
    public static final String READ_GROUP_SAMPLE_TAG = "SM";
    public static final Set<String> STANDARD_TAGS = new HashSet<String>(Arrays.asList("ID", "CN", "DS", "DT", "FO", "KS", "LB", "PG", "PI", "PL", "PM", "PU", "SM"));

    public SAMReadGroupRecord(String id) {
        this.mReadGroupId = id;
    }

    public SAMReadGroupRecord(String id, SAMReadGroupRecord srcProgramRecord) {
        this.mReadGroupId = id;
        for (Map.Entry<String, String> entry : srcProgramRecord.getAttributes()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getId() {
        return this.getReadGroupId();
    }

    public String getReadGroupId() {
        return this.mReadGroupId;
    }

    public String getSample() {
        return this.getAttribute(READ_GROUP_SAMPLE_TAG);
    }

    public void setSample(String value) {
        this.setAttribute(READ_GROUP_SAMPLE_TAG, value);
    }

    public String getLibrary() {
        return this.getAttribute(LIBRARY_TAG);
    }

    public void setLibrary(String value) {
        this.setAttribute(LIBRARY_TAG, value);
    }

    public String getPlatformUnit() {
        return this.getAttribute(PLATFORM_UNIT_TAG);
    }

    public void setPlatformUnit(String pu) {
        this.setAttribute(PLATFORM_UNIT_TAG, pu);
    }

    public String getPlatform() {
        return this.getAttribute(PLATFORM_TAG);
    }

    public void setPlatform(String platform) {
        this.setAttribute(PLATFORM_TAG, platform);
    }

    public Date getRunDate() {
        String dt = this.getAttribute(DATE_RUN_PRODUCED_TAG);
        if (dt == null) {
            return null;
        }
        return new Iso8601Date(dt);
    }

    public String getFlowOrder() {
        return this.getAttribute(FLOW_ORDER_TAG);
    }

    public void setFlowOrder(String flowOrder) {
        this.setAttribute(FLOW_ORDER_TAG, flowOrder);
    }

    public String getKeySequence() {
        return this.getAttribute(KEY_SEQUENCE_TAG);
    }

    public void setKeySequence(String keySequence) {
        this.setAttribute(KEY_SEQUENCE_TAG, keySequence);
    }

    public void setRunDate(Date runDate) {
        if (runDate != null && !(runDate instanceof Iso8601Date)) {
            runDate = new Iso8601Date(runDate);
        }
        this.setAttribute(DATE_RUN_PRODUCED_TAG, runDate != null ? runDate.toString() : null);
    }

    public String getSequencingCenter() {
        return this.getAttribute(SEQUENCING_CENTER_TAG);
    }

    public void setSequencingCenter(String center) {
        this.setAttribute(SEQUENCING_CENTER_TAG, center);
    }

    public String getDescription() {
        return this.getAttribute(DESCRIPTION_TAG);
    }

    public void setDescription(String description) {
        this.setAttribute(DESCRIPTION_TAG, description);
    }

    public Integer getPredictedMedianInsertSize() {
        String stringRep = this.getAttribute(PREDICTED_MEDIAN_INSERT_SIZE_TAG);
        if (stringRep == null) {
            return null;
        }
        return Integer.parseInt(stringRep);
    }

    public void setPredictedMedianInsertSize(Integer predictedMedianInsertSize) {
        this.setAttribute(PREDICTED_MEDIAN_INSERT_SIZE_TAG, predictedMedianInsertSize == null ? null : predictedMedianInsertSize.toString());
    }

    public String getProgramGroup() {
        return this.getAttribute(PROGRAM_GROUP_TAG);
    }

    public void setProgramGroup(String programGroup) {
        this.setAttribute(PROGRAM_GROUP_TAG, programGroup);
    }

    public String getPlatformModel() {
        return this.getAttribute(PLATFORM_MODEL_TAG);
    }

    public void setPlatformModel(String platformModel) {
        this.setAttribute(PLATFORM_MODEL_TAG, platformModel);
    }

    public boolean equivalent(SAMReadGroupRecord that) {
        return this.attributesEqual(that);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMReadGroupRecord that = (SAMReadGroupRecord)o;
        if (!this.attributesEqual(that)) {
            return false;
        }
        return !(this.mReadGroupId != null ? !this.mReadGroupId.equals(that.mReadGroupId) : that.mReadGroupId != null);
    }

    public int hashCode() {
        return this.mReadGroupId.hashCode();
    }

    @Override
    Set<String> getStandardTags() {
        return STANDARD_TAGS;
    }

    @Override
    public String getSAMString() {
        return new SAMTextHeaderCodec().getRGLine(this);
    }

    public static enum PlatformValue {
        CAPILLARY,
        LS454,
        ILLUMINA,
        SOLID,
        HELICOS,
        IONTORRENT,
        ONT,
        PACBIO;

    }
}

