/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;

class QueryOpBuilder {
    static final String READ_PREFERENCE_META_OPERATOR = "$readPreference";
    private DBObject query;
    private DBObject orderBy;
    private DBObject hintObj;
    private String hintStr;
    private boolean explain;
    private boolean snapshot;
    private ReadPreference readPref;
    private DBObject specialFields;

    public QueryOpBuilder addQuery(DBObject query) {
        this.query = query;
        return this;
    }

    public QueryOpBuilder addOrderBy(DBObject orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public QueryOpBuilder addHint(String hint) {
        this.hintStr = hint;
        return this;
    }

    public QueryOpBuilder addHint(DBObject hint) {
        this.hintObj = hint;
        return this;
    }

    public QueryOpBuilder addSpecialFields(DBObject specialFields) {
        this.specialFields = specialFields;
        return this;
    }

    public QueryOpBuilder addExplain(boolean explain) {
        this.explain = explain;
        return this;
    }

    public QueryOpBuilder addSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public QueryOpBuilder addReadPreference(ReadPreference readPref) {
        this.readPref = readPref;
        return this;
    }

    public DBObject get() {
        DBObject lclQuery = this.query;
        if (lclQuery == null) {
            lclQuery = new BasicDBObject();
        }
        if (this.hasSpecialQueryFields()) {
            DBObject queryop = this.specialFields == null ? new BasicDBObject() : this.specialFields;
            this.addToQueryObject(queryop, "$query", lclQuery, true);
            this.addToQueryObject(queryop, "$orderby", this.orderBy, false);
            if (this.hintStr != null) {
                this.addToQueryObject(queryop, "$hint", this.hintStr);
            }
            if (this.hintObj != null) {
                this.addToQueryObject(queryop, "$hint", this.hintObj);
            }
            if (this.explain) {
                queryop.put("$explain", true);
            }
            if (this.snapshot) {
                queryop.put("$snapshot", true);
            }
            if (this.readPref != null && this.readPref != ReadPreference.primary()) {
                queryop.put(READ_PREFERENCE_META_OPERATOR, this.readPref.toDBObject());
            }
            return queryop;
        }
        return lclQuery;
    }

    private boolean hasSpecialQueryFields() {
        if (this.readPref != null) {
            return true;
        }
        if (this.specialFields != null) {
            return true;
        }
        if (this.orderBy != null && this.orderBy.keySet().size() > 0) {
            return true;
        }
        return this.hintStr != null || this.hintObj != null || this.snapshot || this.explain;
    }

    private void addToQueryObject(DBObject dbobj, String field, DBObject obj, boolean sendEmpty) {
        if (obj == null) {
            return;
        }
        if (!sendEmpty && obj.keySet().size() == 0) {
            return;
        }
        this.addToQueryObject(dbobj, field, obj);
    }

    private void addToQueryObject(DBObject dbobj, String field, Object obj) {
        if (obj == null) {
            return;
        }
        dbobj.put(field, obj);
    }
}

