/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.broadinstitute.gatk.engine.walkers.Multiplexer;
import org.broadinstitute.gatk.utils.commandline.ArgumentDefinition;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatch;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatchSite;
import org.broadinstitute.gatk.utils.commandline.ArgumentSource;
import org.broadinstitute.gatk.utils.commandline.ParsingEngine;

public class ArgumentMatches
implements Iterable<ArgumentMatch> {
    Map<ArgumentMatchSite, ArgumentMatch> argumentMatches = new TreeMap<ArgumentMatchSite, ArgumentMatch>();
    ArgumentMatch MissingArgument = new ArgumentMatch();

    @Override
    public Iterator<ArgumentMatch> iterator() {
        return this.getUniqueMatches().iterator();
    }

    public ArgumentMatches() {
    }

    public ArgumentMatches(ArgumentMatch match) {
        this.mergeInto(match);
    }

    public int size() {
        return this.argumentMatches.size();
    }

    boolean hasMatch(ArgumentMatchSite site) {
        return this.argumentMatches.containsKey(site);
    }

    ArgumentMatch getMatch(ArgumentMatchSite site) {
        if (!this.argumentMatches.containsKey(site)) {
            throw new IllegalArgumentException("Site does not contain an argument: " + site);
        }
        return this.argumentMatches.get(site);
    }

    boolean hasMatch(ArgumentDefinition definition) {
        return this.findMatches(definition).size() > 0;
    }

    ArgumentMatches findMatches(ParsingEngine parsingEngine, ArgumentSource argumentSource) {
        List<ArgumentDefinition> sourceDefinitions = parsingEngine.selectBestTypeDescriptor(argumentSource.field.getType()).createArgumentDefinitions(argumentSource);
        ArgumentMatches matches = new ArgumentMatches();
        for (ArgumentMatch argumentMatch : this.getUniqueMatches()) {
            if (!sourceDefinitions.contains(argumentMatch.definition)) continue;
            matches.mergeInto(argumentMatch);
        }
        return matches;
    }

    ArgumentMatches findMatches(ArgumentDefinition definition) {
        ArgumentMatches matches = new ArgumentMatches();
        for (ArgumentMatch argumentMatch : this.argumentMatches.values()) {
            if (argumentMatch.definition != definition) continue;
            matches.mergeInto(argumentMatch);
        }
        return matches;
    }

    ArgumentMatches findSuccessfulMatches() {
        ArgumentMatches matches = new ArgumentMatches();
        for (ArgumentMatch argumentMatch : this.argumentMatches.values()) {
            if (argumentMatch.definition == null) continue;
            matches.mergeInto(argumentMatch);
        }
        return matches;
    }

    ArgumentMatches findUnmatched() {
        ArgumentMatches matches = new ArgumentMatches();
        for (ArgumentMatch argumentMatch : this.argumentMatches.values()) {
            if (argumentMatch.definition != null) continue;
            matches.mergeInto(argumentMatch);
        }
        return matches;
    }

    ArgumentMatches transform(Multiplexer multiplexer, Object key) {
        ArgumentMatches newArgumentMatches = new ArgumentMatches();
        for (ArgumentMatch match : this.argumentMatches.values()) {
            newArgumentMatches.mergeInto(match.transform(multiplexer, key));
        }
        return newArgumentMatches;
    }

    void mergeInto(ArgumentMatch match) {
        boolean definitionExists = false;
        for (ArgumentMatch argumentMatch : this.getUniqueMatches()) {
            if (argumentMatch.definition != match.definition || !argumentMatch.tags.equals(match.tags)) continue;
            argumentMatch.mergeInto(match);
            for (ArgumentMatchSite site : match.sites.keySet()) {
                this.argumentMatches.put(site, argumentMatch);
            }
            definitionExists = true;
        }
        if (!definitionExists) {
            for (ArgumentMatchSite site : match.sites.keySet()) {
                this.argumentMatches.put(site, match);
            }
        }
    }

    private Set<ArgumentMatch> getUniqueMatches() {
        return new LinkedHashSet<ArgumentMatch>(this.argumentMatches.values());
    }
}

