/*==============================================================================

FICHIER     : [tampon.h]

DATE        : 2005/12/0006 20:46:47

CREATEUR    : [Linux!jef]

COMMENTAIRE :

================================================================================

==============================================================================*/

#ifndef __TAMPON_H__
#define __TAMPON_H__

#include <pthread.h>
#include <semaphore.h>

#define MAX_CB	5
#define RSIZE		4096


typedef struct DEF_BUFFER
{
	char data[RSIZE];
	int lg;
	struct DEF_BUFFER * next;
} TBuffer;

typedef struct
{
	int nCb;
	int (* callBack[MAX_CB])();
} TCbArray;

typedef struct DEF_FIFO
{
	struct DEF_STREAM * reader;
	char * oFifo;
	int rmF;
	int fifoFdR;
	int fifoFdW;
	pthread_t thread;
	sem_t 	wSem;
	pthread_mutex_t aMutex;
	TBuffer * head;
	TBuffer * tail;
	struct DEF_FIFO * next;
} TFifo;

typedef struct DEF_STREAM
{
	char * command;
	TCbArray cb;
	TFifo * oFifos;
	pid_t pid;
	void (* endCallBack)();
	void * arg;
	pthread_t thread;
	int threadKilledF;
	struct DEF_STREAM * next;
	struct DEF_STREAM * up;
	struct DEF_STREAM * parent;
} TStream;

#define IsCB( s )		( (s) && (s)->cb.nCb )

typedef struct DEF_STAGE
{
	char * command;
	pid_t pid;
	struct DEF_STAGE * next;
} TStage;


typedef struct DEF_TAMPON
{
	TStream * stream;
	TStage * stages;
	int nProc;
	int nThread;
	long long estimRSize;
	double lPct;
	void * userData;
	int (* callBack)( long long rSize, double pct, void * userData );
} Tampon;


/*@$#[tampon.c] global proto. AutoProtoSigV1.1. date: 106/01/17 21:39:59 */
#include "proto.h"
#ifdef __cplusplus
extern "C" {
#endif
Tampon *CreateTampon PROTO((char *command));
TStream *StreamAddBrother PROTO((TStream *stream, char *command, TCbArray *cb, char *oFile));
TStream *StreamAddSon PROTO((TStream *parent, char *command, TCbArray *cb, char *oFile));
void SetStreamEndCb PROTO((TStream *stream, void (*endCb)(), void *arg));
int TamponAddStage PROTO((Tampon *tampon, char *sysCmd));
int TamponRun PROTO((Tampon *tampon, int (*uiCB)()));
int TamponDestroy PROTO((Tampon *tampon));
#ifdef __cplusplus
}
#endif
/*@$% end of AutoProtoSigV1.1 (Dont remove this line) [-I ../include]*/

#endif	/* __TAMPON_H__ */

